module net.BurtonRadons.spyl.valueInteger;

private import net.BurtonRadons.spyl.value;
private import net.BurtonRadons.spyl.valueFloat;
private import net.BurtonRadons.spyl.valueType;
private import std.c.stdio;
private import std.math;

class IntegerType : TypeValue
{
    private static IntegerType singleton;
    private static bit locked = true;
    
    this ()
    {
        assert (!locked);
    }
    
    static IntegerType create ()
    {
        if (singleton === null)
        {
            locked = false;
            singleton = new IntegerType;
            locked = true;
        }
        return singleton;
    }
    
    char [] doc ()
    {
        return "An integer type.";
    }
    
    Value call (Value [] args)
    {
        Value result;
        
        assert (args.length == 1);
        result = args [0].castTo (this);
        assert ((IntegerValue) result);
        return result;
    }
}

class IntegerValue : Value
{
    long content; /**< Actual value. */
    
    /** Assign the parameter. */
    this (long content)
    {
        this.content = content;
    }
    
    override char [] typeName ()
    {
        return "Integer";
    }
    
    override char [] repr ()
    {
        char [64] buffer;
        int length;
        
        length = sprintf (buffer, "%d", content);
        return buffer [0 .. length].dup;
    }
    
    override Value opAdd (Value other)
    {
        if (cast (IntegerValue) other)
            return new IntegerValue (content + (cast (IntegerValue) other).content);
        return super.add (other);
    }
    
    override Value opSub (Value other)
    {
        if (cast (IntegerValue) other)
            return new IntegerValue (content - (cast (IntegerValue) other).content);
        return super.sub (other);
    }
    
    override Value opMul (Value other)
    {
        if (cast (IntegerValue) other)
            return new IntegerValue (content * (cast (IntegerValue) other).content);
        return super.mul (other);
    }
    
    override Value opPow (Value other)
    {
        if (cast (IntegerValue) other)
        {
            long ocontent = ((IntegerValue) other).content;
            
            if (ocontent >= 0)
                return new IntegerValue (math.pow ((double) content, (double) ocontent));
            return new FloatValue (math.pow ((double) content, (double) ocontent));
        }
        
        return super.pow (other);
    }
    
    override Value castTo (Value other)
    {
        if ((FloatType) other)
            return new FloatValue (content);
        if ((IntegerType) other)
            return this;
        return super.castTo (other);
    }
    
    override Value opNeg ()
    {
        return new IntegerValue (-content);
    }
}
